/* How to use the DHT-22 sensor with Arduino uno
   Temperature and humidity sensor
   More info: http://www.ardumotive.com/how-to-use-dht-22-sensor-en.html
   Dev: Michalis Vasilakis // Date: 1/7/2015 // www.ardumotive.com 
*/

//Libraries
#include <DHT.h>
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

//Constants
#define DHTPIN 2     // what pin we're connected to
#define DHTTYPE DHT22   // DHT 22  (AM2302)
DHT dht(DHTPIN, DHTTYPE); //// Initialize DHT sensor for normal 16mhz Arduino

long previousMillis = 0;        // will store last time LED was updated
long interval = 1000;           // interval at which to blink (milliseconds)
long interval2 = 2000; 

LiquidCrystal_I2C lcd(0x27,20,4); 

//Variables
int chk;
float hum=0;  //Stores humidity value
float temp=0; //Stores temperature value

// diameter of anemometer
float radius= 2.75; //inches from center pin to middle of cup
float diameter = radius * 2; //inches from center pin to middle of cup
float mph;
float kmh;

// read RPM
int half_revolutions = 0;
float rpm = 0;
unsigned long lastmillis = 0;

void setup()
{
  Serial.begin(115200);
  dht.begin();
  lcd.init();
  lcd.setBacklight(HIGH);

  pinMode(DHTPIN, INPUT_PULLUP); 
  attachInterrupt(A0, rpm_fan, FALLING);
}

void loop()
{
  
  //Read data and store it to variables hum and temp
  unsigned long currentMillis = millis();
 
  if(currentMillis - previousMillis > interval) {  
 
               if(currentMillis - previousMillis > interval2) {
                  // save the last time you blinked the LED 
                  previousMillis = currentMillis;   

                detachInterrupt(A0);//Disable interrupt when calculating
                 rpm = half_revolutions * 30; // Convert frequency to RPM, note: 60 works for one interruption per full rotation. For two interrupts per full rotation use half_revolutions * 30.
                // Serial.print("RPM =t"); //print the word "RPM" and tab.
                // Serial.print(rpm); // print the rpm value.
                 //Serial.print("t Hz=t"); //print the word "Hz".
                // Serial.print(half_revolutions/2); //print revolutions per second or Hz. And print new line or enter. divide by 2 if 2 interrupts per revolution
                 
                 attachInterrupt(A0, rpm_fan, FALLING); //enable interrupt
                 mph = diameter * 3.14 * rpm * 60 / 63360;
                 //mph = mph * 3.5; // calibration factor for anemometer accuracy, adjust as necessary
                 kmh = mph * 1.60934;
                 
                 lcd.clear();
                 lcd.setCursor(0,0);
                 lcd.print("Actual WindSpeed");
                 lcd.setCursor(0,1);
                 lcd.print(kmh); 
                 lcd.print(" Km/h");
                 Serial.println(kmh);
                 Serial.println(" Wind");
                 half_revolutions = 0; // Restart the RPM counter
              } else{
                   hum = dht.readHumidity();
                   temp = dht.readTemperature();
                    //Print temp and humidity values to serial monitor
                    Serial.println("Humidity: ");
                    Serial.println(hum);
                    Serial.println(" %, Temp: ");
                    Serial.println(temp);
                    Serial.println(" Celsius");
                    
                    lcd.clear();
                    lcd.setCursor(0,0);
                    lcd.print(temp);
                    lcd.print((char)223);
                    lcd.print("C ");
                    lcd.setCursor(0,1);
                    lcd.print(hum);
                    lcd.print(" %");
                }
  }
}

void rpm_fan(){
  half_revolutions++;
}
